<%@ page import="java.util.*, ibase.utility.UserInfoBean, ibase.webitm.ejb.vhb.msq1.CostDetails" %>
<%@ page language="java" contentType="text/html; charset=ISO-8859-15" pageEncoding="UTF-8" %>
<%
    UserInfoBean userInfo = (UserInfoBean) session.getAttribute("USER_INFO");
    if (userInfo == null) {
        out.print("Invalid session.");
        return;
    }
    String itemCode = request.getParameter("ITEM_CODE") != null ? request.getParameter("ITEM_CODE") : "";
    String type     = request.getParameter("type") != null ? request.getParameter("type") : "both";

    if (itemCode.trim().isEmpty()) {
        out.print("<p style='color:red;'>Item code is missing.</p>");
        return;
    }

    CostDetails details = new CostDetails(userInfo);
    Map<String, List<List<String>>> dataMap = null;
    try {
        dataMap = details.getItemDetails(itemCode);
    } catch (Exception e) {
        out.print("<p style='color:red;'>Error retrieving item details: " + e.getMessage() + "</p>");
        return;
    }

    List<List<String>> costList  = dataMap.get("cost");
    List<List<String>> priceList = dataMap.get("price");
%>

<html>
<head>
    <title>Item Details - <%= type.toUpperCase() %></title>
    <link type="text/css" rel="stylesheet" href="/ibase/webitm/css/sidePanelDisplay.css">
</head>
<body>
<% if ("cost".equals(type) || "both".equals(type)) { %>
    <h2>Costing Details</h2>
    <table border="1" class="itemtbl">
        <tr>
        <th>ITEM CODE</th>
        <th>ITEM DESCRIPTION</th>
        <th>RM COST</th>
        <th>PM COST</th>
        <th>OTHER COST</th>
        <th>EFFECTIVE FROM</th>
        <th>VALID UPTO</th>
        <th>COST PER UNIT</th>
        </tr>
        <% if (costList != null && !costList.isEmpty()) {
             for (List<String> row : costList) { %>
               <tr>
               <% for (String col : row) { %>
               <td><%= col %></td> <% } %>
               </tr>
        <%   }
           } else { %>
               <tr>
               <td colspan="8" style="color:red;">No cost details available.</td>
               </tr>
        <% } %>
    </table>
<% } %>

<% if ("price".equals(type) || "both".equals(type)) { %>
    <h2>Price List Details</h2>
    <table border="1" class="itemtbl">
        <tr>
        <th>ITEM CODE</th>
        <th>ITEM DESCRIPTION</th>
        <th>RATE</th>
        <th>EFFECTIVE FROM</th>
        <th>VALID UPTO</th>
        <th>CURRENCY</th>
        <th>PREVIOUS NRV</th>
        </tr>
        <% if (priceList != null && !priceList.isEmpty()) {
             for (List<String> row : priceList) { %>
               <tr>
               <% for (String col : row) { %>
               <td><%= col %></td><% } %>
               </tr>
        <%   }
           } else { %>
               <tr>
               <td colspan="7" style="color:red;">No price list details available.</td>
               </tr>
        <% } %>
    </table>
<% } %>
</body>
</html>
